<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;

class OrderModel extends Model 
{

    protected $table = 'order';
    public $timestamps = true;
    protected $fillable = array('user_id', 'shipping_id', 'payment_id', 'order_total', 'order_status', 'order_date');
    protected $visible = array('user_id', 'shipping_id', 'payment_id', 'order_total', 'order_status', 'order_date');

    public function paymentof()
    {
        return $this->belongsTo('PaymentModel');
    }

    public function orderDetails()
    {
        return $this->hasMany('OrderDetailsModel');
    }

    public function customerof()
    {
        return $this->belongsTo('UserModel');
    }

    public function orderDetails()
    {
        return $this->belongsTo('ShippingModel');
    }

}